/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.AgentContainer;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NodeFailureMonitor;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceManager;
import jade.core.VerticalCommand;
import jade.core.nodeMonitoring.NodeMonitoringService;
import jade.core.nodeMonitoring.UDPMonitorClient;
import jade.core.nodeMonitoring.UDPMonitorServer;
import jade.core.nodeMonitoring.UDPNodeFailureMonitor;
import jade.core.nodeMonitoring.UDPNodeMonitoringSlice;
import jade.util.Logger;
import java.util.Enumeration;
import java.util.Hashtable;

public class UDPNodeMonitoringService
extends NodeMonitoringService {
    private static final String PREFIX = "jade_core_nodeMonitoring_UDPNodeMonitoringService_";
    public static final String NAME = "jade.core.nodeMonitoring.UDPNodeMonitoring";
    public static final String PORT = "jade_core_nodeMonitoring_UDPNodeMonitoringService_port";
    public static final String PING_DELAY = "jade_core_nodeMonitoring_UDPNodeMonitoringService_pingdelay";
    public static final String PING_DELAY_LIMIT = "jade_core_nodeMonitoring_UDPNodeMonitoringService_pingdelaylimit";
    public static final String UNREACHABLE_LIMIT = "jade_core_nodeMonitoring_UDPNodeMonitoringService_unreachablelimit";
    public static final int DEFAULT_PORT = 28000;
    public static final int DEFAULT_PING_DELAY = 1000;
    public static final int DEFAULT_PING_DELAY_LIMIT = 3000;
    public static final int DEFAULT_UNREACHABLE_LIMIT = 10000;
    public static final String ORPHAN_NODE = "Orphan-Node";
    private static final String[] OWNED_COMMANDS = new String[]{"Node-Unreachable", "Node-Unreachable", "Orphan-Node"};
    private UDPMonitorServer myServer;
    private Hashtable myClients = new Hashtable(2);
    private ServiceManager myServiceManager;
    private ServiceComponent localSlice = new ServiceComponent();
    private Filter incFilter = new UDPMonitorIncomingFilter();
    static /* synthetic */ Class class$jade$core$nodeMonitoring$UDPNodeMonitoringSlice;

    public String getName() {
        return NAME;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myServiceManager = ac.getServiceManager();
        if (ac.getMain() != null) {
            String host = Profile.getDefaultNetworkName();
            int port = UDPNodeMonitoringService.getPosIntValue(p, PORT, 28000);
            int pingDelay = UDPNodeMonitoringService.getPosIntValue(p, PING_DELAY, 1000);
            int pingDelayLimit = UDPNodeMonitoringService.getPosIntValue(p, PING_DELAY_LIMIT, 3000);
            int unreachLimit = UDPNodeMonitoringService.getPosIntValue(p, UNREACHABLE_LIMIT, 10000);
            try {
                this.myServer = new UDPMonitorServer(this, host, port, pingDelay, pingDelayLimit, unreachLimit);
                this.myServer.start();
                this.myLogger.log(Logger.INFO, "UDPMonitorServer successfully started. Port = " + port + " pingdelaylimit = " + pingDelayLimit + " unreachablelimit = " + unreachLimit);
            }
            catch (Exception e) {
                String s = "Error creating UDP monitoring server";
                this.myLogger.log(Logger.SEVERE, s);
                throw new ProfileException(s, e);
            }
        }
    }

    public NodeFailureMonitor getFailureMonitor() {
        if (this.myServer != null) {
            return new UDPNodeFailureMonitor(this.myServer, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.myServer != null) {
            this.myServer.stop();
            this.myServer = null;
        }
        Hashtable hashtable = this.myClients;
        synchronized (hashtable) {
            Enumeration en = this.myClients.elements();
            while (en.hasMoreElements()) {
                UDPMonitorClient client = (UDPMonitorClient)en.nextElement();
                client.stop();
            }
            this.myClients.clear();
        }
    }

    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.incFilter;
        }
        return null;
    }

    public Class getHorizontalInterface() {
        return class$jade$core$nodeMonitoring$UDPNodeMonitoringSlice == null ? (class$jade$core$nodeMonitoring$UDPNodeMonitoringSlice = UDPNodeMonitoringService.class$("jade.core.nodeMonitoring.UDPNodeMonitoringSlice")) : class$jade$core$nodeMonitoring$UDPNodeMonitoringSlice;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientsPingDelay(int delay) {
        Hashtable hashtable = this.myClients;
        synchronized (hashtable) {
            Enumeration en = this.myClients.elements();
            while (en.hasMoreElements()) {
                UDPMonitorClient client = (UDPMonitorClient)en.nextElement();
                client.setPingDelay(delay);
            }
        }
    }

    private static int getPosIntValue(Profile p, String paramName, int defaultValue) {
        int value = Integer.valueOf(p.getParameter(paramName, "-1"));
        if (value >= 0) {
            return value;
        }
        return defaultValue;
    }

    void activateUDP(Node n, long key) {
        block6: {
            if (this.myServer == null) break block6;
            this.myLogger.log(Logger.CONFIG, "Requesting UDP activation to node " + n.getName());
            try {
                UDPNodeMonitoringSlice slice = (UDPNodeMonitoringSlice)this.getSlice(n.getName());
                try {
                    slice.activateUDP(this.myServiceManager.getLocalAddress(), this.myServer.getHost(), this.myServer.getPort(), this.myServer.getPingDelay(), key);
                }
                catch (IMTPException imtpe) {
                    slice = (UDPNodeMonitoringSlice)this.getFreshSlice(n.getName());
                    slice.activateUDP(this.myServiceManager.getLocalAddress(), this.myServer.getHost(), this.myServer.getPort(), this.myServer.getPingDelay(), key);
                }
            }
            catch (NullPointerException npe) {
                this.myLogger.log(Logger.WARNING, "Can't monitor node " + n.getName() + ". UDPNodeMonitoringService not installed.");
            }
            catch (ServiceException se) {
                this.myLogger.log(Logger.WARNING, "Can't monitor node " + n.getName() + ". Service error on remote node: " + se.getMessage());
            }
            catch (IMTPException imtpe1) {
                this.myLogger.log(Logger.WARNING, "Can't monitor node " + n.getName() + ". Node unreachable.");
                imtpe1.printStackTrace();
            }
        }
    }

    void deactivateUDP(Node n, long key) {
        try {
            UDPNodeMonitoringSlice slice = (UDPNodeMonitoringSlice)this.getSlice(n.getName());
            if (slice != null) {
                slice.deactivateUDP(this.myServiceManager.getLocalAddress(), key);
            }
        }
        catch (Exception e) {}
    }

    private void startUDPClient(String label, String host, int port, int pingDelay, long key) throws ServiceException {
        try {
            UDPMonitorClient client = new UDPMonitorClient(this.getLocalNode(), host, port, pingDelay, key);
            this.myClients.put(label, client);
            client.start();
            this.myLogger.log(Logger.INFO, "UDP Monitor Client for " + label + " successfully started. Host = " + host + " port = " + port + " pingdelay = " + pingDelay);
        }
        catch (Exception e) {
            this.myClients.remove(label);
            throw new ServiceException("Error starting UDP Monitor client.", e);
        }
    }

    private void stopUDPClient(String label, long key) {
        UDPMonitorClient client = (UDPMonitorClient)this.myClients.get(label);
        if (client != null && (key == -1L || key == client.getKey())) {
            client.stop();
            this.myLogger.log(Logger.INFO, "UDP Monitor Client for " + label + " stopped.");
            this.myClients.remove(label);
        }
    }

    void handleOrphanNode(String nodeID) {
        try {
            GenericCommand cmd = new GenericCommand(ORPHAN_NODE, NAME, null);
            cmd.addParam(nodeID);
            this.submit(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UDPMonitorIncomingFilter
    extends Filter {
        private UDPMonitorIncomingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            String name = cmd.getName();
            Object[] params = cmd.getParams();
            if (name.equals("Dead-Platform-Manager")) {
                String address = (String)params[0];
                UDPNodeMonitoringService.this.stopUDPClient(address, -1L);
            } else if (name.equals("Dead-Replica")) {
                String address = (String)params[0];
                UDPNodeMonitoringService.this.stopUDPClient(address, -1L);
            }
            return true;
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return UDPNodeMonitoringService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return UDPNodeMonitoringService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the local IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("H-ACTIVATEUDP")) {
                    String label = (String)params[0];
                    String host = (String)params[1];
                    int port = (Integer)params[2];
                    int pingDelay = (Integer)params[3];
                    long key = (Long)params[4];
                    UDPNodeMonitoringService.this.startUDPClient(label, host, port, pingDelay, key);
                } else if (cmdName.equals("H-DEACTIVATEUDP")) {
                    String label = (String)params[0];
                    long key = (Long)params[1];
                    UDPNodeMonitoringService.this.stopUDPClient(label, key);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }
    }
}

